

<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtener los datos enviados por AJAX
    $ida = $_POST['ida'];
    $cupon = $_POST['cupon'];
    $valor = $_POST['valor'];
    $tipo = $_POST['tipo'];
    $fecha_inicio = $_POST['fecha_inicio'];
    $fecha_fin = $_POST['fecha_fin'];
    $cantidad_disponible = $_POST['cantidad_disponible'];

    // Conectar con la base de datos
    include 'conn.php';

    if ($conn->connect_error) {
        echo('<p>Error al conectar con el servidor MySQL: ' . $conn->connect_error . '</p>');
    } else {
        // Preparar la consulta SQL
        $sql = "INSERT INTO cupones (ida, cupon, valor, tipo, fecha_inicio, fecha_fin, cantidad_disponible)
                VALUES (?, ?, ?, ?, ?, ?, ?)";

        // Preparar la sentencia
        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            echo("Error al preparar la consulta: " . $conn->error);
        }

        // Vincular los parámetros y sus tipos
        $stmt->bind_param("ssisssi", $ida, $cupon, $valor, $tipo, $fecha_inicio, $fecha_fin, $cantidad_disponible);

        // Ejecutar la sentencia
        if ($stmt->execute()) {
            // Éxito al insertar los datos
            echo "Cupon creado";
        } else {
            // Error al insertar los datos
            echo "Error al insertar los datos: " . $stmt->error;
        }

        // Cerrar la sentencia y la conexión
        $stmt->close();
        $conn->close();
    }
} else {
    echo "Error: Método de solicitud incorrecto";
}
?>


