<?php

// Mostrar errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'conn.php';

$idr = $_POST['idr'];

// Modificamos la consulta para incluir un JOIN con la tabla proveedores
$sql = "
    SELECT reservas.*, proveedores.empresa, generales.tipo_de_cambio
    FROM reservas 
    LEFT JOIN proveedores ON reservas.proveedor_id = proveedores.id 
    LEFT JOIN generales ON reservas.ida = generales.ida
    WHERE reservas.idr = '$idr'
";

$result = $conn->query($sql);

// Array para almacenar los resultados
$reservas = array();

if ($result->num_rows > 0) {
    // Recorrer los resultados y agregarlos al array
    while ($row = $result->fetch_assoc()) {
        $service = $row['service'];
        if ($service == 'roa') {
            $row['service'] = 'Roundtrip Airport';
        } elseif ($service == 'ona') {
            $row['service'] = 'One Way Arrival';
        } elseif ($service == 'ond') {
            $row['service'] = 'One Way Departure';
        } elseif ($service == 'tra') {
            $row['service'] = 'Transfer';
        } elseif ($service == 'trr') {
            $row['service'] = 'Transfer Roundtrip';
        } elseif ($service == 'ope') {
            $row['service'] = 'Open Service';
        } elseif ($service == 'act') {
            $row['service'] = 'Activity';
        } else {
            $row['service'] = 'Sin servicio asignado';
        }
        if ($row['shopping'] == 1) {
            $row['shopping'] = 'YES';
        } else {
            $row['shopping'] = 'NO';
        }

        $reserva = array(
            "id" => $row["id"],
            "name" => $row["name"],
            "email" => $row["email"],
            "phone" => $row["phone"],
            "pax" => $row["pax"],
            "service" => $row["service"],
            "arrival_pickup" => $row["arrival_pickup"],
            "arrival_hotel" => $row["arrival_hotel"],
            "arrival_date" => $row["arrival_date"],
            "arrival_time" => $row["arrival_time"],
            "arrival_airline" => $row["arrival_airline"],
            "arrival_flight" => $row["arrival_flight"],
            "departure_hotel" => $row["departure_hotel"],
            "departure_destino" => $row["departure_destino"],
            "departure_date" => $row["departure_date"],
            "departure_time" => $row["departure_time"],
            "departure_pickuptime" => $row["departure_pickuptime"],
            "departure_airline" => $row["departure_airline"],
            "departure_flight" => $row["departure_flight"],
            "stop" => $row["stop"],
            "babyseat" => $row["babyseat"],
            "boosterseat" => $row["boosterseat"],
            "carseat" => $row["carseat"],
            "adults" => $row["adults"],
            "teens" => $row["teens"],
            "kids" => $row["kids"],
            "idr" => $row["idr"],
            "total" => $row["total"],
            "status" => $row["status"],
            "pagado" => $row["pagado"],
            "balance" => $row["balance"],
            "car" => $row["car"],
            "agencia" => $row["agencia"],
            "chofer" => $row["chofer"],
            "obs" => $row["obs"],
            "obs_int" => $row["obs_int"],
            "shopping" => $row["shopping"],
            "noTotal" => $row["noTotal"],
            "costo_proveedor" => $row["costo_proveedor"],
            // Datos del proveedor
            "nombre_proveedor" => $row["empresa"],
            "folio" => $row["folio"],
            "currency" => $row["currency"],
            "tipo_de_cambio" => $row["tipo_de_cambio"],

            
        );

        // Agregar la reserva al array de resultados
        $reservas[] = $reserva;
    }
} else {
    // Si no hay resultados, enviar un mensaje de no resultados para DataTables
    $reservas = array();
}

// Convertir el array a formato JSON y enviar como respuesta
echo json_encode(array("data" => $reservas));

// Cerrar la conexión
$conn->close();

?>
