<?php
// Mostrar errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'conn.php';

$ida = $_POST['ida'];
$fecha = $_POST['fecha'];

$conn->set_charset("utf8mb4");

// Consulta preparada con LEFT JOIN para obtener la empresa del proveedor
$sql = "SELECT reservas.*, proveedores.empresa 
        FROM reservas 
        LEFT JOIN proveedores ON reservas.proveedor_id = proveedores.id 
        WHERE reservas.ida = ? 
        AND reservas.arrival_date = ? 
        AND reservas.status != '4'
        AND (reservas.service = 'ona' OR reservas.service = 'roa')";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(["error" => "Error preparando la consulta: " . htmlspecialchars($conn->error)]);
    exit;
}

$stmt->bind_param("ss", $ida, $fecha);
$stmt->execute();
$result = $stmt->get_result();

$reservas = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        // Mapear el nombre del servicio usando un switch
        switch ($row['service']) {
            case 'roa':
                $row['service'] = 'Roundtrip Airport';
                $hotel = $row['arrival_hotel'];
                break;
            case 'ona':
                $row['service'] = 'One Way Airport';
                $hotel = $row['arrival_hotel'];
                break;
            case 'ond':
                $row['service'] = 'One Way Departure';
                $hotel = $row['departure_hotel'];
                break;
            case 'tra':
                $row['service'] = 'Transfer';
                $hotel = $row['arrival_pickup'] . ' - ' . $row['arrival_hotel'];
                break;
            case 'ope':
                $row['service'] = 'Open Service';
                $hotel = $row['arrival_pickup'];
                break;
            default:
                $row['service'] = 'Sin servicio asignado';
                $hotel = '';
                break;
        }

        // Construir las observaciones
        $observaciones = $row['obs'];
        if (!empty($row['obs_int'])) {
            $observaciones .= ' ' . $row['obs_int'] . '.';
        }
        if ((int)$row['babyseat'] > 0) {
            $observaciones .= " Baby seat: " . $row['babyseat'] . ".";
        }
        if ((int)$row['boosterseat'] > 0) {
            $observaciones .= " Booster seat: " . $row['boosterseat'] . ".";
        }
        if ((int)$row['carseat'] > 0) {
            $observaciones .= " Car seat: " . $row['carseat'] . ".";
        }
        if ((int)$row['shopping'] > 0) {
            $observaciones .= " Shopping stop: Yes.";
        }

        // Agregar el registro completo al array de resultados
        $row['arrival_hotel'] = $hotel;
        $row['obs'] = $observaciones;
        $reservas[] = $row;
    }
}

// Enviar la respuesta en formato JSON
echo json_encode(["data" => $reservas]);

// Cerrar la conexión
$conn->close();
?>
