<?php
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
 //establecemos español mexico como idioma para las fechas



include 'conn.php';
include 'ida.php';
$conn->set_charset("utf8mb4");

// Aquí, eliminas duplicados basándote en tu criterio elegido
// Aquí, eliminas duplicados basándote en el identificador único de la reserva (idr)


$sql_delete = "DELETE FROM reservas WHERE id NOT IN (
    SELECT id FROM (
        SELECT MAX(id) as id
        FROM reservas
        WHERE ida = ?
        GROUP BY name, arrival_date, departure_date, service
    ) as subquery
) AND ida = ?";


$stmt_delete = $conn->prepare($sql_delete);
if (!$stmt_delete) {
    echo "Error preparando la consulta: " . htmlspecialchars($conn->error);
    exit;
}

$stmt_delete->bind_param("ss", $ida, $ida);
$stmt_delete->execute();

// Ajusta tu script PHP para usar sentencias preparadas

$sql = "SELECT *,
        proveedores.empresa,
        CASE 
            WHEN service = 'ona' THEN arrival_date
            WHEN service = 'ond' THEN departure_date
            WHEN service = 'roa' THEN arrival_date
            WHEN service = 'tra' THEN departure_date
            WHEN service = 'trr' THEN arrival_date
            WHEN service = 'ope' THEN departure_date
            ELSE NULL
        END AS serviceDate
        FROM reservas 
        LEFT JOIN proveedores ON reservas.proveedor_id = proveedores.id
        WHERE reservas.ida = ? 
        AND reservas.status <> 4
        ORDER BY reservas.id DESC";



$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo "Error preparando la consulta: " . htmlspecialchars($conn->error);
    exit;
}
$stmt->bind_param("s", $ida);


$stmt->execute();
$result = $stmt->get_result();

if ($result === false) {
    echo json_encode([
        "data" => [],
        "error" => "Error en la consulta SQL: " . $conn->error
    ]);
    $conn->close();
    exit;
}


// Crear un array con las reservas
// Crear un array con las reservas
$reservas = array();
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        if (empty($row['car'])) {
            $row['car'] = "Sin vehículo";
        }
        switch ($row['service']) {
            case 'ona':
                $row['serviceDate'] = $row['arrival_date'];
                $row['serviceText'] = 'Llegada';
                $row['hotel'] = $row['arrival_hotel'];
                break;
            case 'ond':
                $row['serviceDate'] = $row['departure_date'];
                $row['serviceText'] = 'Salida';
                $row['hotel'] = $row['departure_hotel'];
                break;
            case 'roa':
                $row['serviceDate'] = $row['arrival_date'];
                $row['serviceText'] = 'Llegada';
                $row['hotel'] = $row['arrival_hotel'];
                break;
            case 'tra':
                $row['serviceDate'] = $row['arrival_date'];
                $row['serviceText'] = 'Transfer';
                $row['hotel'] = $row['arrival_pickup'] . ' -->' . $row['arrival_hotel'];
                break;
            case 'trr':
                $row['serviceDate'] = $row['arrival_date'];
                $row['serviceText'] = 'Transfer Roundtrip';
                $row['hotel'] = $row['arrival_pickup'] . ' --> ' . $row['arrival_hotel'];
                break;

            case 'ope':
                $row['serviceDate'] = $row['arrival_date'];
                $row['serviceText'] = 'Open Service';
                $row['hotel'] = $row['arrival_pickup'] . ' --> ' . $row['arrival_hotel'];
                break;
            case 'act':
                $row['serviceDate'] = $row['arrival_date'];
                $row['serviceText'] = 'Actividad';
                $row['hotel'] = $row['arrival_pickup'] . ' -->' . $row['arrival_hotel'];
                break;
            default:
                $row['serviceDate'] = "No definido";
        }
        $reservas[] = $row;
    }
}



// Enviar el array de reservas en formato JSON
echo json_encode(["data" => $reservas]);

// Cerrar la conexión
$conn->close();
?>