<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'conn.php';
include 'ida.php';

// Verificar que el ID de la reserva sea proporcionado (necesario para la actualización)
if (!isset($_GET['idr'])) {
    echo json_encode(['status' => 'error', 'message' => 'Falta el ID de la reserva para actualizar.']);
    exit();
}

$idr = $_GET['idr']; // ID de la reserva que se quiere actualizar

// Crear un array para almacenar las partes de la consulta SQL de actualización
$fields = [];
$values = [];
$obs_requested = 0; // Valor por defecto es false
$shopping_requested = 0; // Valor por defecto es false
// Verificar y agregar campos opcionales para actualizar
if (isset($_GET['name'])) {
    $fields[] = 'name = ?';
    $values[] = $_GET['name'];
}

if (isset($_GET['email'])) {
    $fields[] = 'email = ?';
    $values[] = $_GET['email'];
}

if (isset($_GET['phone'])) {
    $fields[] = 'phone = ?';
    $values[] = $_GET['phone'];
}

if (isset($_GET['adults'])) {
    $adults = $_GET['adults'] ?? 0;
    $teens = $_GET['teens'] ?? 0;
    $kids = $_GET['kids'] ?? 0;
    $pax = $adults + $teens + $kids;
    $fields[] = 'pax = ?';
    $values[] = $pax;
    
    // Definir el tipo de vehículo basado en el número de pasajeros
    if ($pax <= 5) {
        $car = 'SUBURBAN';
    } elseif ($pax <= 10) {
        $car = 'VAN';
    } else {
        $car = 'SPRINTER';
    }
    $fields[] = 'car = ?';
    $values[] = $car;
}

if (isset($_GET['total'])) {
    $fields[] = 'total = ?';
    $values[] = floatval($_GET['total']);
}

if (isset($_GET['arrival_hotel'])) {
    $fields[] = 'arrival_hotel = ?';
    $values[] = $_GET['arrival_hotel'];
}

if (isset($_GET['arrival_date'])) {
    $arrival_date = date('Y-m-d', strtotime($_GET['arrival_date']));
    $fields[] = 'arrival_date = ?';
    $values[] = $arrival_date;
}

if (isset($_GET['arrival_time'])) {
    $fields[] = 'arrival_time = ?';
    $values[] = $_GET['arrival_time'];
}

if (isset($_GET['arrival_airline'])) {
    $fields[] = 'arrival_airline = ?';
    $values[] = $_GET['arrival_airline'];
}

if (isset($_GET['babyseat'])) {
    $fields[] = 'babyseat = ?';
    $values[] = $_GET['babyseat'];
}

if (isset($_GET['carseat'])) {
    $fields[] = 'carseat = ?';
    $values[] = $_GET['carseat'];
}

if (isset($_GET['boosterseat'])) {
    $fields[] = 'boosterseat = ?';
    $values[] = $_GET['boosterseat'];
}

if (isset($_GET['shopping'])) {
    $fields[] = 'shopping = ?';
    $values[] = $_GET['shopping'];
    $shopping_requested = 1;
}

if (isset($_GET['obs'])) {
    $fields[] = 'obs = ?';
    $values[] = $_GET['obs'];
    $obs_requested = 1; // Se ha solicitado una actualización de observaciones
}

if (isset($_GET['status'])) {
    $fields[] = 'status = ?';
    $values[] = $_GET['status'];
}

if (isset($_GET['service'])) {
    $fields[] = 'service = ?';
    $values[] = $_GET['service'];
}

if (isset($_GET['agencia'])) {
    $fields[] = 'agencia = ?';
    $values[] = $_GET['agencia'];
}

// Si no se ha proporcionado ningún campo para actualizar, no hacemos nada
if (empty($fields)) {
    echo json_encode(['status' => 'error', 'message' => 'No se ha proporcionado ningún campo para actualizar.']);
    exit();
}

// Construir la consulta de actualización
$sql = "UPDATE reservas SET " . implode(", ", $fields) . " WHERE idr = ?";
$values[] = $idr;

// Preparar la consulta
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    echo json_encode(['status' => 'error', 'message' => 'Error en la preparación de la consulta: ' . $conn->error]);
    exit();
}

// Vincular los parámetros de forma dinámica
$types = str_repeat('s', count($values)); // Todos los valores serán tratados como strings ('s')
$stmt->bind_param($types, ...$values);

// Ejecutar la consulta
if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Great! The reservation has been updated. Do you need anything else?', 'shopping_requested' => $shopping_requested, 'obs_requested' => $obs_requested]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error al actualizar la reserva.']);
}

// Cerrar la declaración y conexión
$stmt->close();
$conn->close();

?>
