<?php
// Mostrar errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'conn.php';

$ida = $_POST['ida'];
$fecha = $_POST['fecha'];

$conn->set_charset("utf8mb4");

// Consulta preparada con LEFT JOIN para obtener la empresa del proveedor
$sql = "SELECT reservas.*, proveedores.empresa 
        FROM reservas 
        LEFT JOIN proveedores ON reservas.proveedor_id = proveedores.id 
        WHERE reservas.ida = ? 
        AND reservas.departure_date = ? 
        AND reservas.status != '4'
        AND (reservas.service = 'ond' OR reservas.service = 'roa')";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(["error" => "Error preparando la consulta: " . htmlspecialchars($conn->error)]);
    exit;
}

$stmt->bind_param("ss", $ida, $fecha);
$stmt->execute();
$result = $stmt->get_result();

$reservas = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        // Mapear el nombre del servicio usando un switch
        switch ($row['service']) {
            case 'roa':
                $row['service'] = 'Roundtrip Airport';
                break;
            case 'ona':
                $row['service'] = 'One Way Airport';
                break;
            case 'ond':
                $row['service'] = 'One Way Departure';
                break;
            case 'ope':
                $row['service'] = 'Open Service';
                break;
            default:
                $row['service'] = 'Sin servicio asignado';
                break;
        }

            $observaciones = $row['obs'];

            // Añadir observaciones internas si existen
            if (!empty($row['obs_int'])) {
                $observaciones .= $row['obs_int'] . ".";
            }
            // Añadir información de babyseat, boosterseat, y carseat si alguno es mayor a 0
            if ((int)$row['babyseat'] > 0) {
                $observaciones .= " Baby seat: " . $row['babyseat'] . ".";
            }
            if ((int)$row['boosterseat'] > 0) {
                $observaciones .= " Booster seat: " . $row['boosterseat'] . ".";
            }
            if ((int)$row['carseat'] > 0) {
                $observaciones .= " Car seat: " . $row['carseat'] . ".";
            }

        // Agregar la observación al array
        $row['obs'] = $observaciones;

        // Agregar el registro completo al array de resultados
        $reservas[] = $row;
    }
}

// Enviar la respuesta en formato JSON
echo json_encode(["data" => $reservas]);

// Cerrar la conexión
$conn->close();
?>

