<?php
header("Content-Type: application/json");
require_once "conn.php"; 

$data = json_decode(file_get_contents("php://input"), true);
$startDate = $data['start_date'];
$endDate = $data['end_date'];

// Query SQL
$query = "SELECT 
    r.agencia, r.total, r.arrival_date, r.departure_date, r.status, 
    r.arrival_pickup, r.arrival_hotel, r.departure_hotel, r.departure_destino,
    r.idr, r.chofer, r.car, r.obs, r.pax, r.service, r.shopping, r.folio, r.name,
    p.empresa AS proveedor,

    CONCAT(r.arrival_airline, ' - ', r.arrival_flight) AS arrival_info,
    CONCAT(r.departure_airline, ' - ', r.departure_flight) AS departure_info,

    CASE 
        WHEN r.service = 'ona' THEN r.arrival_date
        WHEN r.service = 'ond' THEN r.departure_date
        ELSE r.arrival_date
    END AS fecha_mostrar,

    CASE 
        WHEN r.service = 'ona' THEN r.arrival_pickup 
        ELSE r.arrival_pickup
    END AS pickup_mostrar,

    CASE 
        WHEN r.service = 'ona' THEN r.arrival_hotel
        ELSE r.arrival_hotel
    END AS destino_mostrar,

    CASE 
        WHEN r.service = 'ona' THEN 'Llegada' 
        WHEN r.service = 'ond' THEN 'Salida' 
        ELSE 'Traslado' 
    END AS servicio_mostrar,

    CONCAT(r.obs, 
        CASE 
            WHEN r.shopping = 1 THEN ' - Requiere Shopping Stop' 
            ELSE '' 
        END, 
        ' ', r.obs_int) AS observaciones

FROM reservas r
LEFT JOIN proveedores p ON r.proveedor_id = p.id 

WHERE (r.arrival_date BETWEEN ? AND ? OR r.departure_date BETWEEN ? AND ?)
AND r.status <> 4
";

$stmt = $conn->prepare($query);
$stmt->bind_param("ssss", $startDate, $endDate, $startDate, $endDate);
$stmt->execute();
$result = $stmt->get_result();

$reservas = [];
while ($row = $result->fetch_assoc()) {
    $reservas[] = $row;
}

echo json_encode(["reservas" => $reservas], JSON_PRETTY_PRINT);

$stmt->close();
$conn->close();
?>