<?php

//mostrar errores

ini_set('display_errors', 1);

ini_set('display_startup_errors', 1);

error_reporting(E_ALL);

// Incluir el archivo de conexión

include 'conn.php';
include 'ida.php';

if (isset($_POST['id']) && !isset($_POST['update']) && !isset($_POST['insert']) && !isset($_POST['eliminar'])) {

  $id = $_POST['id'];

  $stmt = $conn->prepare("SELECT * FROM zonas WHERE id = ?");

  $stmt->bind_param("i", $id);

  $stmt->execute();



  // Vincular los resultados a variables

  $resultado = $stmt->get_result();



  // Obtener los datos en un array asociativo

  while ($fila = $resultado->fetch_assoc()) {

    // Procesar el estado

    if ($fila['status'] == 1) {

      $status = 'Activo';

    } else {

      $status = '';

    }



    // Crear un array asociativo para cada fila

    $datos[] = array(

      'id' => $fila['id'],

      'zona' => $fila['zona'],

      'status' => $status,

      'empresa' => $ida

  );

  }

  echo json_encode(array("data" => $datos));

// verificamos si se reqiere insertar una nueva zona

} elseif (isset($_POST['insert'])) {

  $zona = $_POST['zona'];

 

  //insertamos en la tabla

  $stmt = $conn->prepare("INSERT INTO zonas (zona, ida) VALUES (?, ?)");

  $stmt->bind_param("ss", $zona, $ida);

  $stmt->execute();



  if ($stmt->affected_rows > 0) {

    echo json_encode(array('status' => 'success', 'message' => '¡Perfecto! La nueva zona se ha agregado exitosamente. Para completar el proceso, dirígete a la sección de TARIFAS y agrega el costo correspondiente a esta zona.'));

  } else {

    echo json_encode(array('status' => 'error', 'message' => 'La inserción falló: ' . $stmt->error));

  }



} elseif (isset($_POST['eliminar'])) {

  $id = $_POST['id'];



  //actualizamos la tabla

  $stmt = $conn->prepare("UPDATE zonas SET status = 2 WHERE id = ?");

  $stmt->bind_param("i", $id);

  $stmt->execute();



  if ($stmt->affected_rows > 0) {

    echo json_encode(array('status' => 'success', 'message' => 'Actualización realizada con éxito.'));

  } else {

    echo json_encode(array('status' => 'error', 'message' => 'La actualización falló: ' . $stmt->error));

  }



} else {

  $stmt = $conn->prepare("SELECT id, zona, status, ida FROM zonas WHERE status = 1 AND ida = ? ORDER BY zona ASC");
  $stmt->bind_param('s', $ida);
  $stmt->execute();



  // Vincular los resultados a variables

  $stmt->bind_result($id, $zona, $status, $ida);



  $datos = array();



  while ($stmt->fetch()) {

    $datos[] = array(

      'id' => $id,

      'zona' => $zona,

      'status' => $status,

      'empresa' => $ida,

      'statusRespuesta' => 'success'

    );

  }



  echo json_encode(array("data" => $datos));

}
// Cerrar la declaración
$stmt->close();

// Cerrar la conexión
$conn->close();
?>

